//--------------------------------------------------------------------------------

#include "PotholeDetector.h"
#include "PotholeLocation.h"
#include <Particle.h>
#include <AssetTracker.h>

//--------------------------------------------------------------------------------

PotholeDetector::PotholeDetector(queue<PotholeLocation>& theLocations, 
                                 AssetTracker& theTracker) : potholeLocations(theLocations), 
                                                             accelGpsSensor(theTracker)  {
    tick = 0;
    samples = 0;
    total = 0;
    average = 0.0;
    state = PotholeDetector::S_Wait;
}

//--------------------------------------------------------------------------------

void PotholeDetector::execute() {
    switch (state) {
        case PotholeDetector::S_Wait:
            tick++;

            if (tick == 5) {
               state = PotholeDetector::S_ReadSensor;
            }
            else {
               state = PotholeDetector::S_Wait;
            }
            break;

        case PotholeDetector::S_ReadSensor:
            total += accelGpsSensor.readXYZmagnitude();
            samples++;
            tick = 0;
           
            if ( samples == 3) {
                state = PotholeDetector::S_Average;
            }
            else {
                state = PotholeDetector::S_Wait;
            }
            break;

        case PotholeDetector::S_Average:
            average = static_cast<float>(total) / samples;
            total = 0;
            samples = 0;
           
            if( average > 10000.0) {
                state = PotholeDetector::S_Detected;
            }
            else {
                state = PotholeDetector::S_Wait;
            }
            break;

        case PotholeDetector::S_Detected:
            if (accelGpsSensor.gpsFix()) {
                potholeLocations.push(PotholeLocation(accelGpsSensor.readLonDeg(), 
                                                  accelGpsSensor.readLatDeg()));
            }
            else {
                potholeLocations.push(PotholeLocation(-110.987420, 32.248820));
            }
            
            Serial.print("Pothole detected. Pothole queue size: ");
            Serial.println(potholeLocations.size());
            state = PotholeDetector::S_Wait;
            break;
    }
}

//--------------------------------------------------------------------------------
